<?php

/**
 * This is the model class for table "PunktyDziedzinyPracownika".
 *
 * The followings are the available columns in table 'PunktyDziedzinyPracownika':
 * @property double $idPracownika
 * @property double $idDziedziny
 * @property string $nazwa
 * @property double $punkty
 */
class PunktyDziedzinyPracownika extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PunktyDziedzinyPracownika the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'PunktyDziedzinyPracownika';
	}

	public function getPrimaryKey()
	{
		return array( 'idPracownika', 'idDziedziny' );
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idPracownika, idDziedziny, punkty', 'numerical'),
			array('nazwa', 'length', 'max'=>128),

			array('idPracownika, idDziedziny, nazwa, punkty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'dziedzina'=>array(self::BELONGS_TO, 'Dziedzina', 'idDziedziny'),
			'pracownik'=>array(self::BELONGS_TO, 'Pracownik', 'idPracownika'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idPracownika'=>Yii::t('PunktyDziedzinyPracownika', 'idPracownika'),
			'idDziedziny'=>Yii::t('PunktyDziedzinyPracownika', 'idDziedziny'),
			'nazwa'=>Yii::t('PunktyDziedzinyPracownika', 'nazwa'),
			'punkty'=>Yii::t('PunktyDziedzinyPracownika', 'punkty'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('idPracownika', $this->idPracownika);
		$criteria->compare('idDziedziny', $this->idDziedziny);
		$criteria->compare('nazwa', $this->nazwa, true);
		$criteria->compare('punkty', $this->punkty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}
